package org.msh.tb.bd.dashboard.summaryrep.parser;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.summaryrep.data.IndicatorRateData;
import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorData;
import org.msh.utils.date.Period;

import java.util.List;

/**
 * Created by mauri on 23/05/2017.
 * Parses information returned from IndicatorQuery to a SummaryIndicatorData object
 */
public class Indicator11Parser implements IndicatorParser {

    /**
     * The indicator code like 'indicator01' used by UI to generate some components
     */
    private String indicatorCode;

    public Indicator11Parser(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc) {
        Quarter quarter = Quarter.getCurrentQuarter().getPreviousQuarter();

        // total presented manually is not informed
        if (result == null || result.size() == 0) {
            SummaryIndicatorData data = new SummaryIndicatorData(locationDesc, quarter.getQuarter().getKey() + ".2", "" + quarter.getYear(), "indicator11");
            data.addIndicatorRate(null, "Undefined", "dashboard.indicator11.rate");
            data.addIndicatorRate(null, "Undefined", "dashboard.indicator11.rate2");

            return data;
        }

        Object[] o = result.get(0);

        Float rate1 = (Float) o[3];
        Float rate2 = (Float) o[4];

        if (rate1.floatValue() > 100) {
            rate1 = new Float(100);
        }

        SummaryIndicatorData data = new SummaryIndicatorData(locationDesc, quarter.getQuarter().getKey() + ".2", "" + quarter.getYear(), "indicator11");
        data.addIndicatorRate(rate1, "%", "dashboard.indicator11.rate");
        data.addIndicatorRate(null, getABCDRating(rate2), "dashboard.indicator11.rate2");

        return data;
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc, SummaryIndicatorData nationalResult) {
        SummaryIndicatorData data = parse(result, locationDesc);

        for (IndicatorRateData rateData : data.getIndicatorRates()) {
            for (IndicatorRateData natRateData : nationalResult.getIndicatorRates()){

                if (natRateData.getRateDescMsg() != null && rateData.getRateDescMsg() != null &&
                        natRateData.getRateDescMsg().equals(rateData.getRateDescMsg())) {
                    rateData.setNationalRate(natRateData.getRate());
                    break;
                }
            }
        }

        return data;
    }

    @Override
    public Period getPeriod() {
        return DashboardIndicatorUtils.getLastQuarterPeriod();    }

    private String getABCDRating(Float aBCDNumber){
        if (aBCDNumber.intValue() == 1) {
            return "A";
        }

        if (aBCDNumber.intValue() == 2) {
            return "B";
        }

        if (aBCDNumber.intValue() == 3) {
            return "C";
        }

        if (aBCDNumber.intValue() == 4) {
            return "D";
        }

        return "Undefined";
    }

    public String getIndicatorCode() {
        return indicatorCode;
    }

    public void setIndicatorCode(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }
}
